##################################################################
# R code: Exercise 2.11(c)
# File: NeSETAR_estimation.r
#
# INPUT:  jokulsa.dat (1,086 * 32) matrix 
# OUTPUT: Parameter estimates of NeSETAR model and plots of
#         sample ACF and sample PACF of the normalized residuals.
##################################################################
x      <- jokulsa              # Reintroduce the original data set
x[,33] <- (x[,24]+x[,25]+x[,26])/3  # Average temperature (AvT)
x[,34] <- x[,12]^2                  # Quadratic terms
x[,35] <- x[,13]^2
x[,36] <- x[,14]^2
x[,37] <- x[,15]^2
x[,38] <- x[,16]^2
x[,39] <- x[,17]^2
x[,40] <- x[,18]^2
x[,41] <- x[,19]^2
names(x) <- c("Q","Q1","Q2","Q3","Q4","Q5","Q6","Q7","Q8",
  "Q9","Q10","P","P1","P2","P3","P4","P5","P6","P7",
  "P8","P9","P10","Tm","T1","T2","T3","T4","T5","T6",
  "T7","T8","T9","AvT","Ps","P1s","P2s","P3s","P4s",
  "P5s","P6s","P7s")
x1   <- x[x[,3] <= 92 & x[,33] <=-2, ]
fit1 <- lm(Q ~ Q1, x1)
x2   <- x[x[,3] <= 92 & x[,33] > -2 & x[,33] <= 1.8, ]
fit2 <- lm(Q ~ Q1 + Q2 + P1 + Tm - 1, x2)
x3   <- x[x[,3] <= 92 & x[,33] > 1.8, ]
fit3 <- lm(Q ~ Q1 + Q2 + P1s + Tm + T3 -1, x3)
x4   <- x[x[,3] > 92, ]
fit4 <- lm(Q ~ Q1 + Tm + T1 + T3, x4)
res  <- c(1:1085)
for(i in 1:length (resid(fit1))) {
    res[as.integer(names(resid(fit1)[i]))] <- resid(fit1)[i]}
for(i in 1:length (resid(fit2))) {
    res[as.integer(names(resid(fit2)[i]))] <- resid(fit2)[i]}
for(i in 1:length (resid(fit3))) {
    res[as.integer(names(resid(fit3)[i]))] <- resid(fit3)[i]}
for(i in 1:length (resid(fit4))) {
    res[as.integer(names(resid(fit4)[i]))] <- resid(fit4)[i]}
nres <- c(1:185)
for(i in 1:length (resid(fit1))) {
    nres[as.integer(names(resid(fit1)[i]))] <- 
    resid(fit1)[i]/sqrt(1.6)}
for(i in 1:length (resid(fit2))) {
    nres[as.integer(names(resid(fit2)[i]))] <- 
    resid(fit2)[i]/sqrt(20.3)}
for(i in 1:length (resid(fit3))) {
    nres[as.integer(names(resid(fit3)[i]))] <- 
    resid(fit3)[i]/sqrt(49)}
for(i in 1:length (resid(fit4))) {
    nres[as.integer(names(resid(fit4)[i]))] <- 
    resid(fit4)[i]/sqrt(146)}
Normresid.Jokulsa <- nres
Residuals.Jokulsa <- res
Fitted.Jokulsa    <- jokulsa[,1] - Residuals.Jokulsa
Flow.Jokulsa      <- jokulsa[,1]
Jokulsa.fit       <- data.frame(Flow.Jokulsa, Fitted.Jokulsa,
                          Residuals.Jokulsa, Normresid.Jokulsa)
acf(Normresid.Jokulsa)
pacf(Normresid.Jokulsa)
